Rem CreateCharacterStyle.vbs
Rem An InDesign VBScript
Rem
Rem Creates a complete character style based on the first insertion point of the selected text.
Rem When you create a character style "by example" using InDesign's user interface, only those
Rem formatting attributes of the selection which differ from the underlying formatting are
Rem defined in the character style. While this makes InDesign's character styles very flexible, it
Rem differs from the way that other applications define character styles. By defining every attribute,
Rem this script creates character styles that more closely resemble those found in other applications.
Rem
Rem For more on InDesign/InCopy scripting see the documentation included in the Scripting SDK 
Rem available at http://www.adobe.com/devnet/indesign/sdk.html
Rem or visit the InDesign Scirpting User to User forum as http://www.adobeforums.com.
Rem
main
Function main()
	Set myInDesign = CreateObject("InDesign.Application.2021")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInDesign.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll
	If myInDesign.Documents.Count <> 0 Then
	    If myInDesign.Selection.Count = 1 Then
	        Select Case TypeName(myInDesign.Selection.Item(1))
		    Case "InsertionPoint"
	                Set myInsertionPoint = myInDesign.Selection.Item(1)
	                myDisplayDialog myInDesign, myInsertionPoint
		    Case "Character", "Word", "TextStyleRange", "Line", "Paragraph", "TextColumn", "Text", "TextFrame"
	                Set myInsertionPoint = myInDesign.Selection.Item(1).InsertionPoints.Item(1)
	                myDisplayDialog myInDesign, myInsertionPoint
	            Case Else
	                MsgBox "The selected object is not a text object. Select some text and try again."
	        End Select
	    Else
	         MsgBox "Please select some text and try again."
	    End If
	Else
	    MsgBox "No documents are open. Please open a document, select some text, and try again."
	End If
End Function
Rem Display a dialog box.
Function myDisplayDialog(myInDesign, myInsertionPoint)
    Set myDialog = myInDesign.Dialogs.Add
    myDialog.Name = "CreateCharacterStyle"
    With myDialog.DialogColumns.Add
        With .BorderPanels.Add
            With .StaticTexts.Add
                .StaticLabel = "Character Style Name:"
            End With
            With .DialogColumns.Add
                Set myCharacterStyleNameField = .TextEditboxes.Add
                myCharacterStyleNameField.EditContents = "myNewCharacterStyle"
            End With
        End With
    End With
    myResult = myDialog.Show
    If myResult = True Then
        myCharacterStyleName = myCharacterStyleNameField.EditContents
        myDialog.Destroy
        myDefineCharacterStyle myInDesign, myInsertionPoint, myCharacterStyleName
    Else
       myDialog.Destroy
    End If
End Function
Function myDefineCharacterStyle(myInDesign, myInsertionPoint, myCharacterStyleName)
    Set myDocument = myInDesign.ActiveDocument
    Rem Create the character style if it does not already exist. If the character style
    Rem already exists, it will be redefined based on the current selection.
    Err.Clear
    On Error Resume Next
    Set myCharacterStyle = myDocument.CharacterStyles.Item(myCharacterStyleName)
    If Err.Number <> 0 Then
        Set myCharacterStyle = myDocument.CharacterStyles.Add
        myCharacterStyle.Name = myCharacterStyleName
        Err.Clear
    End If
    On Error Goto 0
    myCharacterStyle.AppliedFont = myInsertionPoint.AppliedFont
    myCharacterStyle.FontStyle = myInsertionPoint.FontStyle
    myCharacterStyle.PointSize = myInsertionPoint.PointSize
    myCharacterStyle.Leading = myInsertionPoint.Leading
    myCharacterStyle.AppliedLanguage = myInsertionPoint.AppliedLanguage
    myCharacterStyle.KerningMethod = myInsertionPoint.KerningMethod
    myCharacterStyle.Tracking = myInsertionPoint.Tracking
    myCharacterStyle.Capitalization = myInsertionPoint.Capitalization
    myCharacterStyle.Position = myInsertionPoint.Position
    myCharacterStyle.Ligatures = myInsertionPoint.Ligatures
    myCharacterStyle.NoBreak = myInsertionPoint.NoBreak
    myCharacterStyle.HorizontalScale = myInsertionPoint.HorizontalScale
    myCharacterStyle.VerticalScale = myInsertionPoint.VerticalScale
    myCharacterStyle.BaselineShift = myInsertionPoint.BaselineShift
    myCharacterStyle.Skew = myInsertionPoint.Skew
    myCharacterStyle.FillColor = myInsertionPoint.FillColor
    myCharacterStyle.FillTint = myInsertionPoint.FillTint
    myCharacterStyle.StrokeTint = myInsertionPoint.StrokeTint
    myCharacterStyle.StrokeWeight = myInsertionPoint.StrokeWeight
    myCharacterStyle.OverprintStroke = myInsertionPoint.OverprintStroke
    myCharacterStyle.OverprintFill = myInsertionPoint.OverprintFill
    myCharacterStyle.OTFFigureStyle = myInsertionPoint.OTFFigureStyle
    myCharacterStyle.OTFOrdinal = myInsertionPoint.OTFOrdinal
    myCharacterStyle.OTFFraction = myInsertionPoint.OTFFraction
    myCharacterStyle.OTFDiscretionaryLigature = myInsertionPoint.OTFDiscretionaryLigature
    myCharacterStyle.OTFTitling = myInsertionPoint.OTFTitling
    myCharacterStyle.OTFContextualAlternate = myInsertionPoint.OTFContextualAlternate
    myCharacterStyle.OTFSwash = myInsertionPoint.OTFSwash
    myCharacterStyle.OTFSlashedZero = myInsertionPoint.OTFSlashedZero
    myCharacterStyle.OTFHistorical = myInsertionPoint.OTFHistorical
    myCharacterStyle.OTFStylisticSets = myInsertionPoint.OTFStylisticSets
    myCharacterStyle.StrikeThru = myInsertionPoint.StrikeThru
    If myInsertionPoint.StrikeThru = True Then
        myCharacterStyle.StrikeThroughColor = myInsertionPoint.StrikeThroughColor
        myCharacterStyle.StrikeThroughGapColor = myInsertionPoint.StrikeThroughGapColor
        myCharacterStyle.StrikeThroughGapOverprint = myInsertionPoint.StrikeThroughGapOverprint
        myCharacterStyle.StrikeThroughGapTint = myInsertionPoint.StrikeThroughGapTint
        myCharacterStyle.StrikeThroughOffset = myInsertionPoint.StrikeThroughOffset
        myCharacterStyle.StrikeThroughOverprint = myInsertionPoint.StrikeThroughOverprint
        myCharacterStyle.StrikeThroughTint = myInsertionPoint.StrikeThroughTint
        myCharacterStyle.StrikeThroughType = myInsertionPoint.StrikeThroughType
        myCharacterStyle.StrikeThroughWeight = myInsertionPoint.StrikeThroughWeight
    End If
    myCharacterStyle.StrokeColor = myInsertionPoint.StrokeColor
    myCharacterStyle.StrokeTint = myInsertionPoint.StrokeTint
    myCharacterStyle.StrokeWeight = myInsertionPoint.StrokeWeight
    myCharacterStyle.Tracking = myInsertionPoint.Tracking
    myCharacterStyle.Underline = myInsertionPoint.Underline
    If myInsertionPoint.Underline = True Then
        myCharacterStyle.UnderlineColor = myInsertionPoint.UnderlineColor
        myCharacterStyle.UnderlineGapColor = myInsertionPoint.UnderlineGapColor
        myCharacterStyle.UnderlineGapOverprint = myInsertionPoint.UnderlineGapOverprint
        myCharacterStyle.UnderlineGapTint = myInsertionPoint.UnderlineGapTint
            myCharacterStyle.UnderlineOffset = myInsertionPoint.UnderlineOffset
        myCharacterStyle.UnderlineOverprint = myInsertionPoint.UnderlineOverprint
        myCharacterStyle.UnderlineTint = myInsertionPoint.UnderlineTint
        myCharacterStyle.UnderlineType = myInsertionPoint.UnderlineType
        myCharacterStyle.UnderlineWeight = myInsertionPoint.UnderlineWeight
    End If
    myCharacterStyle.VerticalScale = myInsertionPoint.VerticalScale
End Function

'' SIG '' Begin signature block
'' SIG '' MIIeUwYJKoZIhvcNAQcCoIIeRDCCHkACAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' RHSMxxYmIHT4+wFN8yw6PRz1S5IbF4wc0knY1bXBplag
'' SIG '' ggyUMIIF0DCCBLigAwIBAgIQB3XcWt35KITbGdVVTAfs
'' SIG '' STANBgkqhkiG9w0BAQsFADBsMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2Vy
'' SIG '' dCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMB4XDTE5
'' SIG '' MDEzMTAwMDAwMFoXDTIxMDIwMzEyMDAwMFowgeYxEzAR
'' SIG '' BgsrBgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIB
'' SIG '' AhMIRGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3Jn
'' SIG '' YW5pemF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYD
'' SIG '' VQQGEwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNh
'' SIG '' biBKb3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYD
'' SIG '' VQQLEyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29w
'' SIG '' eSwgTXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIiKXEE3
'' SIG '' 5FJAWPRPxAu4g1GRRZmzrPW3SZL40s8opqkFWksx2dBE
'' SIG '' yP6+N6visRXUyDy+I979oO9tEtHBeYKx1XHy4NOLPl3u
'' SIG '' Lr8rWv5E3hrNw+QRwJvsMJLzBTS44811Rym8ddkt8lpj
'' SIG '' dG1PmC2aZQ73miR88+46IaZDtuabo3corXvrG0wmLFZb
'' SIG '' SrB80HAigwQiwHgh33cI2pPIYA2VdmEv5V3iI+AuYybL
'' SIG '' BPJ32YPqdvcoR3Ml/oYFcFlUb1sliNdngwqEeUTKBWVu
'' SIG '' OTeuRo2gOioizpUxR3cce25eoH8wONWUozkjPwcUEY8I
'' SIG '' RCePRf21c4kjjLGFSmpwEVQVQJcCAwEAAaOCAfEwggHt
'' SIG '' MB8GA1UdIwQYMBaAFI/ofvBtMmoABSPHcJdqOpD/a+rU
'' SIG '' MB0GA1UdDgQWBBSVoz2+cIajBhNjiGb0VJBYxDX9vzAu
'' SIG '' BgNVHREEJzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVM
'' SIG '' QVdBUkUtMjc0ODEyOTAOBgNVHQ8BAf8EBAMCB4AwEwYD
'' SIG '' VR0lBAwwCgYIKwYBBQUHAwMwewYDVR0fBHQwcjA3oDWg
'' SIG '' M4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0VWQ29k
'' SIG '' ZVNpZ25pbmdTSEEyLWcxLmNybDA3oDWgM4YxaHR0cDov
'' SIG '' L2NybDQuZGlnaWNlcnQuY29tL0VWQ29kZVNpZ25pbmdT
'' SIG '' SEEyLWcxLmNybDBLBgNVHSAERDBCMDcGCWCGSAGG/WwD
'' SIG '' AjAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
'' SIG '' Y2VydC5jb20vQ1BTMAcGBWeBDAEDMH4GCCsGAQUFBwEB
'' SIG '' BHIwcDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
'' SIG '' aWNlcnQuY29tMEgGCCsGAQUFBzAChjxodHRwOi8vY2Fj
'' SIG '' ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRFVkNvZGVT
'' SIG '' aWduaW5nQ0EtU0hBMi5jcnQwDAYDVR0TAQH/BAIwADAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAQEADtCQA7go0Xu2UKN6dFPe
'' SIG '' YJbS/OXx3n3IP0K9CGPDozeGV62MvbCp+DuptFa44FYR
'' SIG '' ZuljRXMxCjsjJmkJLD9Hhuik+a23iSwfOAnWK6AY/VoD
'' SIG '' ZatWvGG6mZzMRs/s5Whztt8IRxLMrLbA+ulDkDKTlqqf
'' SIG '' BWN8xAM23VX2IMmPYFXMf1TgyT3rCr2oontG6eWT0VYa
'' SIG '' j8DrYJuWtoNQaHIxSg3lGWyvqi1RwJc7GjVwJObnRCTH
'' SIG '' Faqmfxwry/5jEDjPNNUyDiMWIr2xxCbe5pu759mb9Hjl
'' SIG '' rSakmU9AhIxEURqKA3wmnF9Sw+OnazRGp4bvfkCeWDtK
'' SIG '' LdN4JKj5eh21hDCCBrwwggWkoAMCAQICEAPxtOFfOoLx
'' SIG '' FJZ4s9fYR1wwDQYJKoZIhvcNAQELBQAwbDELMAkGA1UE
'' SIG '' BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
'' SIG '' A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMi
'' SIG '' RGlnaUNlcnQgSGlnaCBBc3N1cmFuY2UgRVYgUm9vdCBD
'' SIG '' QTAeFw0xMjA0MTgxMjAwMDBaFw0yNzA0MTgxMjAwMDBa
'' SIG '' MGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
'' SIG '' dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
'' SIG '' KzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmlu
'' SIG '' ZyBDQSAoU0hBMikwggEiMA0GCSqGSIb3DQEBAQUAA4IB
'' SIG '' DwAwggEKAoIBAQCnU/oPsrUT8WTPhID8roA10bbXx6Ms
'' SIG '' rBosrPGErDo1EjqSkbpX5MTJ8y+oSDy31m7clyK6UXlh
'' SIG '' r0MvDbebtEkxrkRYPqShlqeHTyN+w2xlJJBVPqHKI3zF
'' SIG '' QunEemJFm33eY3TLnmMl+ISamq1FT659H8gTy3WbyeHh
'' SIG '' ivgLDJj0yj7QRap6HqVYkzY0visuKzFYZrQyEJ+d8FKh
'' SIG '' 7+g+03byQFrc+mo9G0utdrCMXO42uoPqMKhM3vELKlhB
'' SIG '' iK4AiasD0RaCICJ2615UOBJi4dJwJNvtH3DSZAmALeK2
'' SIG '' nc4f8rsh82zb2LMZe4pQn+/sNgpcmrdK0wigOXn93b89
'' SIG '' OgklAgMBAAGjggNYMIIDVDASBgNVHRMBAf8ECDAGAQH/
'' SIG '' AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDAzB/BggrBgEFBQcBAQRzMHEwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBJBggr
'' SIG '' BgEFBQcwAoY9aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENB
'' SIG '' LmNydDCBjwYDVR0fBIGHMIGEMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMIIBxAYDVR0gBIIBuzCC
'' SIG '' AbcwggGzBglghkgBhv1sAwIwggGkMDoGCCsGAQUFBwIB
'' SIG '' Fi5odHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9zc2wtY3Bz
'' SIG '' LXJlcG9zaXRvcnkuaHRtMIIBZAYIKwYBBQUHAgIwggFW
'' SIG '' HoIBUgBBAG4AeQAgAHUAcwBlACAAbwBmACAAdABoAGkA
'' SIG '' cwAgAEMAZQByAHQAaQBmAGkAYwBhAHQAZQAgAGMAbwBu
'' SIG '' AHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEA
'' SIG '' bgBjAGUAIABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBl
'' SIG '' AHIAdAAgAEMAUAAvAEMAUABTACAAYQBuAGQAIAB0AGgA
'' SIG '' ZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABB
'' SIG '' AGcAcgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwA
'' SIG '' aQBtAGkAdAAgAGwAaQBhAGIAaQBsAGkAdAB5ACAAYQBu
'' SIG '' AGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
'' SIG '' ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBl
'' SIG '' AHIAZQBuAGMAZQAuMB0GA1UdDgQWBBSP6H7wbTJqAAUj
'' SIG '' x3CXajqQ/2vq1DAfBgNVHSMEGDAWgBSxPsNpA/i/RwHU
'' SIG '' mCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAGTNK
'' SIG '' DIEzN9utNsnkyTq7tRsueqLi9ENCF56/TqFN4bHb6YHd
'' SIG '' nwHy5IjV6f4J/SHB7F2A0vDWwUPC/ncr2/nXkTPObNWy
'' SIG '' GTvmLtbJk0+IQI7N4fV+8Q/GWVZy6OtqQb0c1UbVfEnK
'' SIG '' ZjgVwb/gkXB3h9zJjTHJDCmiM+2N4ofNiY0/G//V4BqX
'' SIG '' i3zabfuoxrI6Zmt7AbPN2KY07BIBq5VYpcRTV6hg5ucC
'' SIG '' EqC5I2SiTbt8gSVkIb7P7kIYQ5e7pTcGr03/JqVNYUvs
'' SIG '' RkG4Zc64eZ4IlguBjIo7j8eZjKMqbphtXmHGlreKuWEt
'' SIG '' k7jrDgRD1/X+pvBi1JlqpcHB8GSUgDGCERcwghETAgEB
'' SIG '' MIGAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xKzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2ln
'' SIG '' bmluZyBDQSAoU0hBMikCEAd13Frd+SiE2xnVVUwH7Ekw
'' SIG '' DQYJYIZIAWUDBAIBBQCggZwwGQYJKoZIhvcNAQkDMQwG
'' SIG '' CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
'' SIG '' AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIHqx8mpkLvxO
'' SIG '' hyvWXQXY0F/Lk+R7i1002aQiYhXd5BUSMDAGCisGAQQB
'' SIG '' gjcCAQwxIjAgoB6AHABBAGQAbwBiAGUAIABJAG4ARABl
'' SIG '' AHMAaQBnAG4wDQYJKoZIhvcNAQEBBQAEggEADz10mviy
'' SIG '' fH065qPyGZUcTto0E8x6j4a5HMUeghij7BkMwUJHtY8k
'' SIG '' C2OK3mk9LnhNWDYngJb5Nt5ROWrRebRSoxanSU69kF4j
'' SIG '' tLvl6RcmwIVBL12VzwnEbTXwQDm3BQxdURK+YwTbKpZv
'' SIG '' PUOEjPetEguQPaBlcHRpNPeHtJmKoqTDXe8y3olYl2qE
'' SIG '' crEvDY6zQqG2sk2XXa/MzT17qGD2/F1fzAUOPqr6pJw6
'' SIG '' EPbxXT72MLN45O6fg9JruK7pj5TA8aE/3ePC4ukjltyw
'' SIG '' tGOQ1Suwbzbqglfz7koFLn1SbC0kO2/BRANVrRdFMrth
'' SIG '' x/Qv+W8h60Y4688ssc1R7v6sAaGCDsgwgg7EBgorBgEE
'' SIG '' AYI3AwMBMYIOtDCCDrAGCSqGSIb3DQEHAqCCDqEwgg6d
'' SIG '' AgEDMQ8wDQYJYIZIAWUDBAIBBQAwdwYLKoZIhvcNAQkQ
'' SIG '' AQSgaARmMGQCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFl
'' SIG '' AwQCAQUABCAJdhwHh7nRdlCHUEyqtDkrDBNalSWdY136
'' SIG '' 1tVv6s5tmQIQFtWGtoUfmqgPr81U6M6Z9hgPMjAyMDEw
'' SIG '' MDQwMDIxMTRaoIILuzCCBoIwggVqoAMCAQICEATNP4Vo
'' SIG '' rnbGG7D+cWDMp20wDQYJKoZIhvcNAQELBQAwcjELMAkG
'' SIG '' A1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZ
'' SIG '' MBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UE
'' SIG '' AxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVz
'' SIG '' dGFtcGluZyBDQTAeFw0xOTEwMDEwMDAwMDBaFw0zMDEw
'' SIG '' MTcwMDAwMDBaMEwxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
'' SIG '' Ew5EaWdpQ2VydCwgSW5jLjEkMCIGA1UEAxMbVElNRVNU
'' SIG '' QU1QLVNIQTI1Ni0yMDE5LTEwLTE1MIIBIjANBgkqhkiG
'' SIG '' 9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6WQ1nPqpmGVkG+QX
'' SIG '' 3LgpNsxnCViFTTDgyf/lOzwRKFCvBzHiXQkYwvaJjGkI
'' SIG '' BCPgdy2dFeW46KFqjv/UrtJ6Fu/4QbUdOXXBzy+nrEV+
'' SIG '' lG2sAwGZPGI+fnr9RZcxtPq32UI+p1Wb31pPWAKoMmki
'' SIG '' E76Lgi3GmKtrm7TJ8mURDHQNsvAIlnTE6LJIoqEUpfj6
'' SIG '' 4YlwRDuN7/uk9MO5vRQs6wwoJyWAqxBLFhJgC2kijE7N
'' SIG '' xtWyZVkh4HwsEo1wDo+KyuDT17M5d1DQQiwues6cZ3o4
'' SIG '' d1RA/0+VBCDU68jOhxQI/h2A3dDnK3jqvx9wxu5CFlM2
'' SIG '' RZtTGUlinXoCm5UUowIDAQABo4IDODCCAzQwDgYDVR0P
'' SIG '' AQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/
'' SIG '' BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCC
'' SIG '' AaEGCWCGSAGG/WwHATCCAZIwKAYIKwYBBQUHAgEWHGh0
'' SIG '' dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwggFkBggr
'' SIG '' BgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABv
'' SIG '' AGYAIAB0AGgAaQBzACAAQwBlAHIAdABpAGYAaQBjAGEA
'' SIG '' dABlACAAYwBvAG4AcwB0AGkAdAB1AHQAZQBzACAAYQBj
'' SIG '' AGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAA
'' SIG '' RABpAGcAaQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABh
'' SIG '' AG4AZAAgAHQAaABlACAAUgBlAGwAeQBpAG4AZwAgAFAA
'' SIG '' YQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBo
'' SIG '' AGkAYwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwA
'' SIG '' aQB0AHkAIABhAG4AZAAgAGEAcgBlACAAaQBuAGMAbwBy
'' SIG '' AHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
'' SIG '' eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9
'' SIG '' bAMVMB8GA1UdIwQYMBaAFPS24SAd/imu0uRhpbKiJbLI
'' SIG '' FzVuMB0GA1UdDgQWBBRWUw/BxgenTdfYbldygFBM5Oye
'' SIG '' wTBxBgNVHR8EajBoMDKgMKAuhixodHRwOi8vY3JsMy5k
'' SIG '' aWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLXRzLmNybDAy
'' SIG '' oDCgLoYsaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3No
'' SIG '' YTItYXNzdXJlZC10cy5jcmwwgYUGCCsGAQUFBwEBBHkw
'' SIG '' dzAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNl
'' SIG '' cnQuY29tME8GCCsGAQUFBzAChkNodHRwOi8vY2FjZXJ0
'' SIG '' cy5kaWdpY2VydC5jb20vRGlnaUNlcnRTSEEyQXNzdXJl
'' SIG '' ZElEVGltZXN0YW1waW5nQ0EuY3J0MA0GCSqGSIb3DQEB
'' SIG '' CwUAA4IBAQAug6FEBUoE47kyUvrZgfAau/gJjSO5PdiS
'' SIG '' oeZGHEovbno8Y243F6Mav1gjskOclINOOQmwLOjH4eLM
'' SIG '' 7ct5a87eIwFH7ZVUgeCAexKxrwKGqTpzav74n8GN0SGM
'' SIG '' 5CmCw4oLYAACnR9HxJ+0CmhTf1oQpvgi5vhTkjFf2IKD
'' SIG '' LW0TQq6DwRBOpCT0R5zeDyJyd1x/T+k5mCtXkkTX726T
'' SIG '' 2UPHBDNjUTdWnkcEEcOjWFQh2OKOVtdJP1f8Cp8jXnv0
'' SIG '' lI3dnRq733oqptJFplUMj/ZMivKWz4lG3DGykZCjXzMw
'' SIG '' YFX1/GswrKHt5EdOM55naii1TcLtW5eC+MupCGxTCbT3
'' SIG '' MIIFMTCCBBmgAwIBAgIQCqEl1tYyG35B5AXaNpfCFTAN
'' SIG '' BgkqhkiG9w0BAQsFADBlMQswCQYDVQQGEwJVUzEVMBMG
'' SIG '' A1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
'' SIG '' ZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBB
'' SIG '' c3N1cmVkIElEIFJvb3QgQ0EwHhcNMTYwMTA3MTIwMDAw
'' SIG '' WhcNMzEwMTA3MTIwMDAwWjByMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2Vy
'' SIG '' dCBTSEEyIEFzc3VyZWQgSUQgVGltZXN0YW1waW5nIENB
'' SIG '' MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
'' SIG '' vdAy7kvNj3/dqbqCmcU5VChXtiNKxA4HRTNREH3Q+X1N
'' SIG '' aH7ntqD0jbOI5Je/YyGQmL8TvFfTw+F+CNZqFAA49y4e
'' SIG '' O+7MpvYyWf5fZT/gm+vjRkcGGlV+Cyd+wKL1oODeIj8O
'' SIG '' /36V+/OjuiI+GKwR5PCZA207hXwJ0+5dyJoLVOOoCXFr
'' SIG '' 4M8iEA91z3FyTgqt30A6XLdR4aF5FMZNJCMwXbzsPGBq
'' SIG '' rC8HzP3w6kfZiFBe/WZuVmEnKYmEUeaC50ZQ/ZQqLKfk
'' SIG '' dT66mA+Ef58xFNat1fJky3seBdCEGXIX8RcG7z3N1k3v
'' SIG '' BkL9olMqT4UdxB08r8/arBD13ays6Vb/kwIDAQABo4IB
'' SIG '' zjCCAcowHQYDVR0OBBYEFPS24SAd/imu0uRhpbKiJbLI
'' SIG '' FzVuMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6enIZ3z
'' SIG '' bcgPMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/
'' SIG '' BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMIMHkGCCsG
'' SIG '' AQUFBwEBBG0wazAkBggrBgEFBQcwAYYYaHR0cDovL29j
'' SIG '' c3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRw
'' SIG '' Oi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRB
'' SIG '' c3N1cmVkSURSb290Q0EuY3J0MIGBBgNVHR8EejB4MDqg
'' SIG '' OKA2hjRodHRwOi8vY3JsNC5kaWdpY2VydC5jb20vRGln
'' SIG '' aUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2hjRo
'' SIG '' dHRwOi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRB
'' SIG '' c3N1cmVkSURSb290Q0EuY3JsMFAGA1UdIARJMEcwOAYK
'' SIG '' YIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxodHRwczov
'' SIG '' L3d3dy5kaWdpY2VydC5jb20vQ1BTMAsGCWCGSAGG/WwH
'' SIG '' ATANBgkqhkiG9w0BAQsFAAOCAQEAcZUS6VGHVmnN793a
'' SIG '' fKpjerN4zwY3QITvS4S/ys8DAv3Fp8MOIEIsr3fzKx8M
'' SIG '' IVoqtwU0HWqumfgnoma/Capg33akOpMP+LLR2HwZYuhe
'' SIG '' giUexLoceywh4tZbLBQ1QwRostt1AuByx5jWPGTlH0gQ
'' SIG '' GF+JOGFNYkYkh2OMkVIsrymJ5Xgf1gsUpYDXEkdws3XV
'' SIG '' k4WTfraSZ/tTYYmo9WuWwPRYaQ18yAGxuSh1t5ljhSKM
'' SIG '' Ycp5lH5Z/IwP42+1ASa2bKXuh1Eh5Fhgm7oMLSttosR+
'' SIG '' u8QlK0cCCHxJrhO24XxCQijGGFbPQTS2Zl22dHv1VjMi
'' SIG '' LyI2skuiSpXY9aaOUjGCAk0wggJJAgEBMIGGMHIxCzAJ
'' SIG '' BgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMx
'' SIG '' GTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNV
'' SIG '' BAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJRCBUaW1l
'' SIG '' c3RhbXBpbmcgQ0ECEATNP4VornbGG7D+cWDMp20wDQYJ
'' SIG '' YIZIAWUDBAIBBQCggZgwGgYJKoZIhvcNAQkDMQ0GCyqG
'' SIG '' SIb3DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDEwMDQw
'' SIG '' MDIxMTRaMCsGCyqGSIb3DQEJEAIMMRwwGjAYMBYEFAMl
'' SIG '' vVBe2pYwLcIvT6AeTCi+KDTFMC8GCSqGSIb3DQEJBDEi
'' SIG '' BCAmawkWrBn12RFtWCGkay3QjYDeghicBXTQLvby8tXz
'' SIG '' njANBgkqhkiG9w0BAQEFAASCAQC4VvJ3FVLFRdc1/Bhd
'' SIG '' qwidoR58M/fB86vxJxvBSZ0jR7Y+5Tfh074irZPJGjBo
'' SIG '' YD9PhpEZFxW5CAShrtphOw8IrmJ2+KnHVdqXQ8EuHbsm
'' SIG '' 3CZbcJe3e3RnYhdjQIIT5+/85I0RSIxfEwIFXjamgwVV
'' SIG '' xnUd20jyZ5jNpqMJtBwG7Tzu0BTMiz04xvTUVfOco0pX
'' SIG '' qK5wy4vJQvxqtVrEMnfz8bYrIfXXcq9wm9GUxfGzO0mn
'' SIG '' p2jnatHKln4zsqlpsVtIKjSY9BqWsFx4K3Qz5Pr1sF+v
'' SIG '' x/5hshGkTZiFMm6hSVHWS4opsIphuzqyZ6n2gtXJt3v3
'' SIG '' uUaAn97bwcus42nw
'' SIG '' End signature block
